"""Stub for .NET System namespace"""
from typing import Any, ClassVar

__all__ = ["DateTime", "TimeSpan"]


class TimeSpan:
    """Représente un intervalle de temps"""
    TotalSeconds: float
    TotalMilliseconds: float
    TotalMinutes: float
    TotalHours: float
    TotalDays: float
    Seconds: int
    Minutes: int
    Hours: int
    Days: int
    
    def __init__(self, days: int = 0, hours: int = 0, minutes: int = 0, 
                 seconds: int = 0, milliseconds: int = 0) -> None: ...
    
    def __add__(self, other: 'TimeSpan') -> 'TimeSpan': ...
    def __sub__(self, other: 'TimeSpan') -> 'TimeSpan': ...
    def __lt__(self, other: 'TimeSpan') -> bool: ...
    def __le__(self, other: 'TimeSpan') -> bool: ...
    def __gt__(self, other: 'TimeSpan') -> bool: ...
    def __ge__(self, other: 'TimeSpan') -> bool: ...


class DateTime:
    """Représente une date et heure"""
    UtcNow: ClassVar['DateTime']
    Now: ClassVar['DateTime']
    MinValue: ClassVar['DateTime']
    MaxValue: ClassVar['DateTime']
    Today: ClassVar['DateTime']
    
    Year: int
    Month: int
    Day: int
    Hour: int
    Minute: int
    Second: int
    Millisecond: int
    
    def __init__(self, year: int = 0, month: int = 0, day: int = 0, 
                 hour: int = 0, minute: int = 0, second: int = 0) -> None: ...
    
    def AddSeconds(self, seconds: float) -> 'DateTime': ...
    def AddMinutes(self, minutes: float) -> 'DateTime': ...
    def AddHours(self, hours: float) -> 'DateTime': ...
    def AddDays(self, days: float) -> 'DateTime': ...
    def AddMilliseconds(self, ms: float) -> 'DateTime': ...
    def AddMonths(self, months: int) -> 'DateTime': ...
    def AddYears(self, years: int) -> 'DateTime': ...
    
    def ToString(self, format: str = "") -> str: ...
    
    def __sub__(self, other: 'DateTime') -> TimeSpan: ...
    def __lt__(self, other: 'DateTime') -> bool: ...
    def __le__(self, other: 'DateTime') -> bool: ...
    def __gt__(self, other: 'DateTime') -> bool: ...
    def __ge__(self, other: 'DateTime') -> bool: ...
    def __eq__(self, other: object) -> bool: ...